package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 用户成绩实体类
*@ Author     : 86187
*@ Date       : 2021/1/7 14:56
 * @author 86187
 */
@Data
@ApiModel(value = "ScoreInfo")
public class ScoreInfo implements Serializable {
    private static final long serialVersionUID = -8644045186424617919L;

    /**
     * 成绩id
     */
    @ApiModelProperty(value = "成绩id",name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id",name = "userId")
    private Integer userId;

    /**
     * 文化成绩
     */
    @ApiModelProperty(value = "文化成绩",name = "cultureGrade")
    private Double cultureGrade;

    /**
     * 专业成绩
     */
    @ApiModelProperty(value = "专业成绩",name = "majorGrade")
    private Double majorGrade;

    /**
     * 语文成绩
     */
    @ApiModelProperty(value = "语文成绩",name = "languageGrade")
    private Double languageGrade;

    /**
     * 数学成绩
     */
    @ApiModelProperty(value = "数学成绩",name = "mathGrade")
    private Double mathGrade;

    /**
     * 英语成绩
     */
    @ApiModelProperty(value = "英语成绩",name = "englishGrade")
    private Double englishGrade;

    /**
     * 物理成绩
     */
    @ApiModelProperty(value = "物理成绩",name = "physicsGrade")
    private Double physicsGrade;

    /**
     * 化学成绩
     */
    @ApiModelProperty(value = "化学成绩",name = "chemistryGrade")
    private Double chemistryGrade;

    /**
     * 生物成绩
     */
    @ApiModelProperty(value = "生物成绩",name = "biologyGrade")
    private Double biologyGrade;

    /**
     * 历史成绩
     */
    @ApiModelProperty(value = "历史成绩",name = "historyGrade")
    private Double historyGrade;

    /**
     * 地理成绩
     */
    @ApiModelProperty(value = "地理成绩",name = "geographyGrade")
    private Double geographyGrade;

    /**
     * 政治成绩
     */
    @ApiModelProperty(value = "政治成绩",name = "politicsGrade")
    private Double politicsGrade;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",name = "creteTime")
    private Date createTime;
    /**
     *更改时间
     */
    @ApiModelProperty(value = "更改时间",name = "updateTime")
    private Date updateTime;
}
