package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Banner;
import cn.wisenergy.model.dto.BannerDto;
import cn.wisenergy.model.vo.AdvertisingQueryVo;
import com.github.pagehelper.PageInfo;
import com.sun.org.apache.xpath.internal.operations.Bool;

/**
 * @ Description: 广告接口定义
 * @ Author     : 86187
 * @ Date       : 2021/1/7 17:08
 */
public interface BannerService {
    /**
     * 添加广告
     *
     * @param advertising 广告信息
     * @return 广告信息
     */
    R<Boolean> add(Banner advertising);

    /**
     * 编辑广告
     *
     * @param advertising 广告信息
     * @return true 成功 false 失败
     */
    R<Boolean> edit(Banner advertising);

    /**
     * 获取详情
     *
     * @param id 广告id
     * @return 详情
     */
    R getById(Integer id);

    /**
     * 获取广告分页列表
     *
     * @param advertisingQueryVo 分页参数
     * @return 分页结果集
     */
    R<PageInfo<BannerDto>> getList(AdvertisingQueryVo advertisingQueryVo);

    /**
     * 开始/暂停投放广告
     *
     * @param id     广告id
     * @param status 1 ：投放 2：暂停投放
     * @return true 成功 false 失败
     */
    R<Boolean> editStatus(Integer id, Integer status);

}
