package cn.wisenergy.service.app;

import java.util.List;

public interface Daosupport {

    /**
     * 查询单一结果集<br/>
     * 并将结果转为<code>int</code>型返回
     * @param sql 查询的sql语句，确定结果为一行一列，且为数字型
     * @param args 对应sql语句中的参数值
     * @return
     */
    Integer queryForInt(String sql, Object... args);


    /**
     * 查询多行结果集<br/>
     * 并将结果转为<code>List<T></code>
     * @param sql 查询的sql语句
     * @param clazz <code><T></code>的Class对象
     * @param args 对应sql语句中的参数值
     * @return  列表中元素为<code>T</code>的<code>List</code>
     */
    <T> List<T> queryForList(String sql, Class<T> clazz, Object... args);
}
