package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;

/**
 * @author 86187
 * @ Description: 短信验证码接口定义
 * @ Author     : 86187
 * @ Date       : 2021/1/15 15:44
 */
public interface SendSmsSerVice {
    /**
     * 发送短信验证码
     *
     * @param phone 手机号
     * @return true 成功 false 失败
     */
    R<Boolean> sendSmCode(String phone);

    /**
     * 在缓存中记录验证码
     *
     * @param phone 手机号
     * @param code  短信验证码
     * @param type  场景类型 1:验证码登录 2:手机注册 3:修改密码 4：找回密码
     * @return 是否成功
     */
    R<String> record(String phone, String code, Integer type);

    /**
     * 验证手机验证码：外部调用
     *
     * @param phone 手机号码
     * @param code  手机验证码
     * @param type  场景类型 1:验证码登录 2:手机注册 3:修改密码 4：找回密码
     * @return 是否通过校验 true通过，false不通过
     */
    R<Boolean> valid(String phone, String code, Integer type);

    /**
     * 验证手机验证码 :内部调用
     *
     * @param phone 手机号码
     * @param code  手机验证码
     * @param type  场景类型 1:验证码登录 2:手机注册 3:修改密码 4：找回密码
     * @return 是否通过校验 true通过，false不通过
     */
    boolean validCode(String phone, String code, Integer type);
}
