package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.BannerMapper;
import cn.wisenergy.model.app.Banner;
import cn.wisenergy.model.dto.BannerDto;
import cn.wisenergy.model.vo.AdvertisingQueryVo;
import cn.wisenergy.service.app.BannerService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;

/**
 * @ Description: 广告接口是实现
 * @ Author     : 86187
 * @ Date       : 2021/1/7 17:07
 */
@Slf4j
@Service
public class BannerServiceImpl extends ServiceImpl<BannerMapper, Banner> implements BannerService {


    @Autowired
    private BannerMapper bannerMapper;

    @Override
    public R<Boolean> add(Banner advertising) {
        log.info("BannerServiceImpl[].add[].input.param:advertising:" + advertising);
        //判断是否存在广告图片，给定初始值
        if (!StringUtils.isEmpty(advertising.getImage())) {
            advertising.setIsHaveImage(1);
        } else {
            advertising.setIsHaveImage(0);
        }
        advertising.setStatus(0);

        //数据添加
        int count = bannerMapper.add(advertising);
        if (count == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    @Override
    public R<Boolean> edit(Banner advertising) {
        log.info("BannerServiceImpl[].getById[].input.param:advertising" + advertising);

        if (null == advertising) {
            return R.error("输入的参数有误");
        }

        int edit = bannerMapper.edit(advertising);

        //判断数据是否修改成功
        if (edit == 0) {
            return R.error("数据修改失败");
        }

        return R.ok(0,true);
    }

    @Override
    public R<Banner> getById(Integer id) {
        log.info("BannerServiceImpl[].getById[].input.param:id" + id);
        if (null == id) {
            return R.error("传入参数无效");
        }
        Banner banner = bannerMapper.getById(id);

        if (null == banner) {
            return R.error("数据获取失败");
        }

        return R.ok(banner);
    }

    @Override
    public R<PageInfo<BannerDto>> getList(AdvertisingQueryVo advertisingQueryVo) {
        log.info("BannerServiceImpl[].getList[].input.param:advertisingQueryVo:" + advertisingQueryVo);
        if (null == advertisingQueryVo) {
            return R.error("输入参数无效");
        }

        //数据验证
        Integer pageNo = advertisingQueryVo.getPageNo();
        Integer pageSize = advertisingQueryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNo || pageNo == 0) {
            pageNo = 1;
        }

        //封装参数
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("pageNo", pageNo - 1);
        map.put("pageSize", pageSize);

        //查询数据;
        List<BannerDto> list = bannerMapper.getList(map);

        //判断数据是否获取成功
        if (CollectionUtils.isEmpty(list)) {
            return R.error("数据查询失败");
        }

        PageInfo<BannerDto> pageInfo = new PageInfo<>();
        pageInfo.setTotal(bannerMapper.count());
        pageInfo.setPageNum(pageNo);
        pageInfo.setPageSize(pageSize);
        pageInfo.setList(list);
        return R.ok(pageInfo);
    }

    @Override
    public R<Boolean> editStatus(Integer id, Integer status) {
        log.info("BannerServiceImpl[].putIn[].input.param,status:{},id" + status, id);
        //判断数据是否正确
        if (null == id ||null==status) {
            return R.error("缺少重要数据");
        }

        //修改广告状态
        int i = bannerMapper.editStatus(id, status);

        //判断数据是否修改成功
        if (i == 0) {
            return R.error("数据修改失败");
        }
        return R.ok(0,true);
    }
}
