package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.common.utils.SecretkeyUtil;
import cn.wisenergy.common.utils.StringUtil;
import cn.wisenergy.mapper.CardMapper;
import cn.wisenergy.mapper.RefillCardMapper;
import cn.wisenergy.model.app.CardInfo;
import cn.wisenergy.model.app.RefillCard;
import cn.wisenergy.model.dto.RefillCardDto;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.service.app.RefillCardService;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service
@Slf4j
public class RefillCardServiceImpl implements RefillCardService {
    @Autowired
    RefillCardMapper refillCardMapper;

    @Autowired
    private CardMapper cardMapper;


    @Override
    @Transactional
    public R<Boolean> add(RefillCard refillCard) {
        log.info("RefillCardServiceImpl[].add[].input.param:refillCard:{}"+refillCard);

        if (refillCard.getCardNumber()==0||null==refillCard.getCardNumber()) {
            return R.error("输入的卡数无效是无效值");
        }
        //设置初始状态
        String time = DateUtil.getTime(new Date(), "yyyy.MM.dd.HH.mm.sss");
        refillCard.setBatchNumber(time);
        refillCard.setIsActivite(1);
        refillCard.setIsMakeCard(0);
        refillCard.setIsDelete(0);
        int add = refillCardMapper.add(refillCard);

        //判断数据是否添加成功
        if (add==0) {
            return R.error("数据添加失败");
        }

        ArrayList<CardInfo> cardInfos = new ArrayList<>();

        //子卡添加
        for (int i = 0; i < refillCard.getCardNumber(); i++) {
            CardInfo cardInfo = new CardInfo();
            cardInfo.setBanthNumber(time);
            cardInfo.setIsDelete(0);
            cardInfo.setMoney("10");
            cardInfo.setStatus(0);
            cardInfo.setLimit(0);
            cardInfo.setSecretKey(SecretkeyUtil.getSecretkey());
            cardInfos.add(cardInfo);
        }
        int add1 = cardMapper.add(cardInfos);

        if (add1==0) {
            R.error("数据添加失败");
        }
        return R.ok(0,true);
    }

    @Override
    public R<Boolean> update(String batchNumber) {
        log.info("RefillCardServiceImpl[].update[].input.param:batchNumber:{}"+batchNumber);
        if (StringUtils.isEmpty(batchNumber)) {
            return R.error("传入参数为空");
        }
        int update = refillCardMapper.update(batchNumber);
        if (update==0) {
            return R.error("数据修改失败");
        }
        return R.ok(0,true);
    }

    @Override
    public R<PageInfo<RefillCardDto>> getList(Integer pageNum, Integer pageSize) {
        log.info("RefillCardServiceImpl[].getList[].input.param:pageNum,pageSize"+pageNum,pageSize);
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }

        //创建参数容器
        HashMap<String, Object> map = new HashMap<>(4);
        map.put("pageNo",pageNum-1);
        map.put("pageSize",pageSize);
        ArrayList<RefillCardDto> refillCardDtos = new ArrayList<>();

        //查询参数
        List<RefillCard> list = refillCardMapper.getList(map);
        for (RefillCard refillCard : list) {
            RefillCardDto refillCardDto = new RefillCardDto();
            BeanUtils.copyProperties(refillCard,refillCardDto);
            refillCardDtos.add(refillCardDto);
        }
        if (refillCardDtos.size()==0) {
            return R.error("用户数据不存在");
        }
        PageInfo<RefillCardDto> refillCardDtoPageInfo = new PageInfo<>();
        refillCardDtoPageInfo.setTotal(refillCardMapper.getUserNumbers());
        refillCardDtoPageInfo.setPageNum(pageNum);
        refillCardDtoPageInfo.setPageSize(pageSize);
        refillCardDtoPageInfo.setList(refillCardDtos);
        return R.ok(refillCardDtoPageInfo);
    }

}
