package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.SchemeRecordMapper;
import cn.wisenergy.mapper.UserVolunteerMapper;
import cn.wisenergy.mapper.VolunteerMapper;
import cn.wisenergy.model.app.SchemeQueryRecord;
import cn.wisenergy.model.app.UserVolunteer;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.model.vo.SchemeRecordQueryVo;
import cn.wisenergy.service.app.SchemeRecordService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @ Description: 方案查询记录接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/8 11:41
 */
@Slf4j
@Service
public class SchemeRecordServiceImpl extends ServiceImpl<SchemeRecordMapper, SchemeQueryRecord> implements SchemeRecordService {
    @Autowired
    private SchemeRecordMapper schemeRecordMapper;

    @Autowired
    private UserVolunteerMapper userVolunteerMapper;

    @Autowired
    private VolunteerMapper volunteerMapper;

    @Override
    public R<SchemeQueryRecord> add(SchemeQueryRecord scheme) {
        log.info("volunteer-service[]SchemeRecordServiceImpl[]getById[]input.param.scheme:" + scheme);
        if (null == scheme) {
            return R.error("入参为空!");
        }

        //保存记录信息
        SchemeQueryRecord schemeQueryRecord = schemeRecordMapper.add(scheme);
        if (null == schemeQueryRecord) {
            return R.error("添加方案记录失败");
        }
        return R.ok(schemeQueryRecord);
    }

    @Override
    public R<PageInfo<SchemeQueryRecord>> getList(SchemeRecordQueryVo queryVo) {
        log.info("volunteer-service[]SchemeRecordServiceImpl[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo || null == queryVo.getUserId()) {
            return R.error("入参为空!");
        }

        pageHandle(queryVo);

        //统计数据总条数
        Map<String, Object> map = new HashMap<>(8);
        map.put("user_id", queryVo.getUserId());
        int total = schemeRecordMapper.count(map);


        //根据用户id,查询方案记录列表
        map.put("startNum", queryVo.getPageSize());
        map.put("endNUm", queryVo.getEndNum());
        List<SchemeQueryRecord> list = schemeRecordMapper.getList(map);
        PageInfo<SchemeQueryRecord> info = new PageInfo<>();
        info.setPageSize(queryVo.getPageSize());
        info.setPageNum(queryVo.getPageNo());
        info.setTotal(total);
        info.setList(list);
        return R.ok(info);
    }

    @Override
    public R<List<Volunteer>> getVolunteerList(Integer userId, Integer recordId) {
        log.info("volunteer-service[]SchemeRecordServiceImpl[]getVolunteerList[]input.param.userId,recordId:" + userId);
        if (null == userId || null == recordId) {
            return R.error("入参为空!");
        }

        //1、根据用户id和方案记录id,获取志愿ids
        QueryWrapper<UserVolunteer> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        queryWrapper.eq("scheme_record_id", recordId);
        List<UserVolunteer> list = userVolunteerMapper.selectList(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return R.ok(new ArrayList<>());
        }

        List<Integer> ids = list.stream().map(UserVolunteer::getVolunteerId).collect(Collectors.toList());
        List<Volunteer> result = volunteerMapper.getListByIds(ids);
        return R.ok(result);
    }


    /**
     * 分页处理
     *
     * @param cameraQueryVo 参数
     */
    private void pageHandle(SchemeRecordQueryVo cameraQueryVo) {
        Integer pageNum = cameraQueryVo.getPageNo();
        Integer pageSize = cameraQueryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        cameraQueryVo.setEndNum(endNum);
        cameraQueryVo.setStartNum(startNum);
        cameraQueryVo.setPageNo(pageNum);
        cameraQueryVo.setPageSize(pageSize);
    }
}
