package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.enums.SceneType;
import cn.wisenergy.service.app.SendSmsSerVice;
import cn.wisenergy.service.cache.Cache;
import cn.wisenergy.service.common.CachePrefix;
import cn.wisenergy.service.common.Common;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ Description: 短信验证码接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/15 15:45
 * @author 86187
 */
@Service
@Slf4j
public class SendSmsSerViceImpl implements SendSmsSerVice {
    @Autowired
    private Cache cache;

    @Override
    public R<Boolean> sendSmCode(String phone) {
        log.info("volunteer-service[]SendSmsSerViceImpl[]sendSmCode[]input.param.phone:" + phone);
        if (StringUtils.isBlank(phone)) {
            return R.error("入参不能为空!");
        }


        return null;
    }

    @Override
    public R<String> record(String phone, String code, Integer scene) {
        String value = SceneType.getNameByCode(scene);
        cache.put(CachePrefix.SMS_CODE.getPrefix() + value + "_" + phone, code, Common.SMS_TIMEOUT);
        return R.ok("缓存验证码成功!");
    }

    @Override
    public R<Boolean> valid(String phone, String code, Integer type) {
        String value = SceneType.getNameByCode(type);
        //获取短信验证码key
        String valCode = CachePrefix.SMS_CODE.getPrefix() + value + "_" + phone;
        //redis中获取验证码
        Object obj = cache.get(valCode);
        if (obj != null && obj.equals(code)) {
            //验证码存在，校验通过，清除验证码缓存
            cache.remove(valCode);
            return R.ok(0, true);
        }
        return R.ok(1, false);
    }

    @Override
    public boolean validCode(String phone, String code, Integer type) {
        //获取短信验证码key
        String valCode = CachePrefix.SMS_CODE.getPrefix() + type + "_" + phone;
        //redis中获取验证码
        Object obj = cache.get(valCode);
        if (obj != null && obj.equals(code)) {
            //验证码存在，校验通过，清除验证码缓存
            cache.remove(valCode);
            return true;
        }
        return false;
    }


}
