package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.UserLimitMapper;
import cn.wisenergy.model.app.UserLimit;
import cn.wisenergy.service.app.UserLimitService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class UserLimitServiceImpl extends ServiceImpl<UserLimitMapper, UserLimit> implements UserLimitService {


    @Override
    public R<UserLimit> getByUserId(Integer userId) {
        log.info("volunteer-service[]UserLimitServiceImpl[]getByUserId[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        //由用户id,获取用户查询次数信息
        QueryWrapper<UserLimit> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        UserLimit userLimit = baseMapper.selectOne(queryWrapper);

        return R.ok(userLimit);
    }
}
