package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.LoginRecordMapper;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.LoginRecord;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.enums.OperationTypeEnum;
import cn.wisenergy.model.vo.UpdatePasswordVo;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserLoginVo;
import cn.wisenergy.model.vo.UserRegisterVo;
import cn.wisenergy.service.app.SendSmsSerVice;
import cn.wisenergy.service.app.UserLoginService;
import cn.wisenergy.service.cache.Cache;
import cn.wisenergy.service.common.Common;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author 86187
 * @ Description: 用户登录相关接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/7 14:22
 */
@Service
@Slf4j
public class UserLoginServiceImpl extends ServiceImpl<UsersMapper, User> implements UserLoginService {
    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private LoginRecordMapper loginRecordMapper;

    @Autowired
    private SendSmsSerVice sendSmsSerVice;

    @Autowired
    private Cache cache;

    @Override
    public R<Boolean> register(UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]register[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参为空!");
        }

        String phone = userVo.getPhone();
        String password = userVo.getPassword();

        //1.检查号码是否重复
        Integer userId = null;
        Boolean bool = checkPhone(phone, userId);
        if (!bool) {
            return R.error("该电话号码" + phone + "已被使用!");
        }

        //2、给密码加密 加密规则，电话号码+明文密码
        String secret = Md5Util.digestMD5(phone + password);

        //3、添加用户信息
        User userInfo = new User();
        userInfo.setPhone(phone);
        userInfo.setPassword(secret);
        userInfo.setIsDelete(0);

        int count = usersMapper.add(userInfo);
        if (count == 0) {
            return R.ok(1, false);
        }

        //4、保存操作记录
        User user=usersMapper.getByPhone(userVo.getPhone());
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setType(OperationTypeEnum.USER_REGISTER.getCode());
        loginRecord.setUserId(user.getId());
        String name = OperationTypeEnum.getByCode(OperationTypeEnum.USER_REGISTER.getCode());
        loginRecord.setOperationName(name);
        int sum = loginRecordMapper.add(loginRecord);
        if (sum == 0) {
            return R.ok(1, false);
        }

        return R.ok(0, true);
    }

    @Override
    public R<Boolean> loginCode(UserLoginVo userVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]loginCode[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getCode()) ||
                StringUtils.isBlank(userVo.getType()) || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        //1、判断手机号账户是否存在
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", userVo.getPhone());
        queryWrapper.eq("is_delete", 0);
        User user = usersMapper.selectOne(queryWrapper);
        if (null == user) {
            return R.error("该手机号未注册,请先注册!");
        }

        //2、判断验证码是否正确
        boolean bool = sendSmsSerVice.validCode(userVo.getPhone(), userVo.getCode(), userVo.getScene());
        return R.ok(bool);
    }

    @Override
    public R<UserInfoVo> login(UserLoginVo userVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]login[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参为空!");
        }

        //1、根据手机号，获取用户信息
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", userVo.getPhone());
        queryWrapper.eq("is_delete", 0);
        User user = usersMapper.selectOne(queryWrapper);
        if (null == user) {
            return R.error("该用户不存在，请您注册账号!");
        }

        //2、判断密码是否正确
        //MD5加密
        String secret = Md5Util.digestMD5(userVo.getPhone() + userVo.getPassword());

        if (!user.getPassword().equals(secret)) {
            return R.error("密码错误，请您输入正确密码!");
        }

        //3、构造返回参数
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUserId(user.getId());
        userInfoVo.setUserName(user.getUserName());
        userInfoVo.setPhone(user.getPhone());

        //3、保存操作记录
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setType(OperationTypeEnum.USER_LOGIN.getCode());
        loginRecord.setUserId(user.getId());
        String name = OperationTypeEnum.getByCode(OperationTypeEnum.USER_LOGIN.getCode());
        loginRecord.setOperationName(name);
        int sum = loginRecordMapper.add(loginRecord);
        if (sum == 0) {
            return R.error("保存操作记录失败!");
        }
        return R.ok(userInfoVo);
    }

    @Override
    public R<Boolean> loginOut(Integer userId) {
        log.info("volunteer-service[]UserLoginServiceImpl[]loginOut[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参为空!");
        }

        //保存用户退出操作
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setType(OperationTypeEnum.USER_OUT.getCode());
        loginRecord.setUserId(userId);
        String name = OperationTypeEnum.getByCode(OperationTypeEnum.USER_OUT.getCode());
        loginRecord.setOperationName(name);
        int sum = loginRecordMapper.add(loginRecord);
        if (sum == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    @Override
    public R<Boolean> updatePassword(UpdatePasswordVo updateVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]loginOut[]input.param.updateVo:" + updateVo);
        if (null == updateVo || null == updateVo.getUserId() || StringUtils.isBlank(updateVo.getNewPassword()) ||
                StringUtils.isBlank(updateVo.getOldPassword())) {
            return R.error("入参为空!");
        }

        //1、获取用户信息
        User user = usersMapper.selectById(updateVo.getUserId());
        if (null == user) {
            return R.error("用户信息不存在,无法修改密码!");
        }

        //2、判断旧密码是否正确
        String password = Md5Util.digestMD5(updateVo.getNewPassword() + user.getPassword());
        if (!user.getPassword().equals(password)) {
            return R.error("旧密码不正确,请从新输入!");
        }

        //3、修改用户密码为新密码
        String newPassword = Md5Util.digestMD5(updateVo.getNewPassword() + user.getPhone());
        user.setPassword(newPassword);
        int count = usersMapper.edit(user);
        if (count == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    @Override
    public R<Boolean> resetPassword(Integer userId) {
        log.info("volunteer-service[]UserLoginServiceImpl[]resetPassword[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参为空!");
        }

        //获取用户信息
        User user = usersMapper.selectById(userId);

        //加密重置密码
        String password = Md5Util.digestMD5(Common.RESET_PASSWORD_VALUE + user.getPhone());
        user.setPassword(password);

        int count = usersMapper.edit(user);
        if (count == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    @Override
    public R<Boolean> smsResetPassword(UserLoginVo userVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]smsResetPassword[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getCode()) ||
                StringUtils.isBlank(userVo.getPassword()) || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        //获取用户信息
        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", userVo.getPhone());
        queryWrapper.eq("is_delete", 0);
        User user = baseMapper.selectOne(queryWrapper);
        if (null == user) {
            return R.error("用户信息不存在，无法重置密码!");
        }

        //验证验证码
        boolean bool = sendSmsSerVice.validCode(userVo.getPhone(), userVo.getCode(), userVo.getScene());
        if (!bool) {
            return R.ok(1, false);
        }

        //3、设置新密码
        String password = Md5Util.digestMD5(userVo.getPassword() + userVo.getPhone());
        user.setPassword(password);
        int count = usersMapper.edit(user);
        if (count == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    private Boolean checkPhone(String phone, Integer userId) {
        //判断是注册还是编辑
        //1、注册-新增
        if (null == userId) {
            //根据电话号码查询用户
            QueryWrapper<User> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("phone", phone);
            queryWrapper.eq("is_delete", 0);
            User user = usersMapper.selectOne(queryWrapper);
            if (null != user) {
                return false;
            }
        }

        //2、编辑
        if (null != userId) {
            //根据电话号码和用户id,统计号码是否重复
            int count = usersMapper.countByPhoneAnsUserId(phone, userId);
            if (count > 0) {
                return false;
            }
        }

        return true;
    }


}
