package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.model.vo.UserShowVo;
import cn.wisenergy.service.app.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @ Description: 用户接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:11
 */
@Service
@Slf4j
public class UserServiceImpl extends ServiceImpl<UsersMapper, User> implements UserService {

    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private ScoreInfoMapper scoreInfoMapper;

    @Autowired
    private LoginRecordMapper loginRecordMapper;

    @Autowired
    private UserLimitMapper userLimitMapper;

    @Autowired
    private PayRecordMapper payRecordMapper;

    @Override
    public R<PageInfo<UserInfoDto>> getUserList(UserQueryVo queryVo) {
        log.info("volunteer_service[]UserServiceImpl[]getUserList[]input.param.queryVo:" + queryVo);
        pageHandle(queryVo);
        //创建参数容器
        HashMap<String, Object> map = new HashMap<>(4);

        //将参数放入容器中
        map.put("pageNo",queryVo.getPageNo()-1);
        map.put("pageSize",queryVo.getPageSize());
        map.put("startTime",queryVo.getStartTime());
        map.put("endTime",queryVo.getEndTime());

        //查询用户数据
        List<User> list1 = usersMapper.getList(map);
        List<UserInfoDto> list = new ArrayList<>();

        //将集合遍历拿出用户id查询成绩信息
        for (User user : list1) {
            UserInfoDto userInfoDto = new UserInfoDto();

            //查询相关信息
            ScoreInfo scoreInfo = scoreInfoMapper.getById(user.getId());
            LoginRecord loginRecord = loginRecordMapper.getById(user.getId());
            UserLimit userLimit = userLimitMapper.getById(user.getId());
            PayRecord byId = payRecordMapper.getById(user.getId());

            //将消息进行同步
            BeanUtils.copyProperties(user,userInfoDto);
            userInfoDto.setUserId(user.getId());
            userInfoDto.setCultureGrade(scoreInfo.getCultureGrade().toString());
            userInfoDto.setMajorGrade(scoreInfo.getMajorGrade().toString());
            userInfoDto.setRegisterTime(user.getCreateTime());
            userInfoDto.setLastLoginTime(loginRecord.getUpdateTime());
            userInfoDto.setQueryLimit(userLimit.getUsableLimit());
            userInfoDto.setMoneyAmount(byId.getMoney());
            userInfoDto.setIp(loginRecord.getIp());
            list.add(userInfoDto);
        }

        PageInfo<UserInfoDto> info = new PageInfo<>();
        info.setPageSize(queryVo.getPageSize());
        info.setPageNum(queryVo.getPageNo());
        info.setTotal(usersMapper.getUserNumbers());
        info.setList(list);
        if (info.getList().size()==0) {
            return R.error("占时还没有用户");
        }
        return R.ok(info);
    }

    @Override
    public R<UserInfoVo> commitUserInfo(UserCommitDto userInfo) {
        log.info("volunteer-service[]UserServiceImpl[]commitUserInfo[]input.param.userInfo:" + userInfo);
        if (null == userInfo) {
            return R.error("入参为空!");
        }

        //1、根据用户id,获取用户信息
        User user = usersMapper.selectById(userInfo.getId());
        if (null == user) {
            return R.error("用户信息不存在!");
        }

        //2、要提交的用户信息
        user.setSchool(userInfo.getSchool());
        user.setSex(userInfo.getSex());
        user.setExamType(userInfo.getStudentType());
        user.setUserName(userInfo.getUserName());
        user.setIsDelete(0);

        //3、要提交的用户的成绩信息
        ScoreInfo scoreInfo = userInfo.getScoreInfo();

        //4、更新用户信息和保存用户成绩
        boolean bool = updateAndSaveUserInfo(user, scoreInfo);
        if (!bool) {
            return R.error("添加用户信息失败!");
        }

        //返回信息
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUserId(userInfo.getId());
        userInfoVo.setUserName(userInfo.getUserName());
        userInfoVo.setPhone(user.getPhone());
        userInfoVo.setSex(userInfo.getSex());
        userInfoVo.setStudentType(userInfo.getStudentType());
        userInfoVo.setUserName(userInfo.getUserName());
        return R.ok(userInfoVo);
    }

    @Override
    public R<Boolean> edit(User user) {
        return null;
    }

    @Override
    public R<Boolean> delete(Integer userId) {
        return null;
    }

    @Override
    public R<UserShowVo> getById(Integer id) {
        log.info("volunteer-service[]UserServiceImpl[]getById[]input.param.id:" + id);
        if (null == id) {
            return R.error("入参为空!");
        }

        //根据id,获取用户信息
        User user = usersMapper.selectById(id);
        if (null == user) {
            return R.error("用户信息不存在!");
        }

        UserShowVo userShowVo = new UserShowVo();
        userShowVo.setId(user.getId());
        userShowVo.setSchool(user.getSchool());
        userShowVo.setSex(user.getSex());
        userShowVo.setStudentType(user.getExamType());
        userShowVo.setUserName(user.getUserName());

        //获取成绩信息
        QueryWrapper<ScoreInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", user.getId());
        ScoreInfo scoreInfo = scoreInfoMapper.selectOne(queryWrapper);
        if (null != scoreInfo) {
            userShowVo.setScoreInfo(scoreInfo);
        }
        return R.ok(userShowVo);
    }

    /**
     * 分页处理方法
     *
     * @param orderQueryVo 参数
     */
    private void pageHandle(UserQueryVo orderQueryVo) {
        Integer pageNum = orderQueryVo.getPageNo();
        Integer pageSize = orderQueryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        orderQueryVo.setEndNum(endNum);
        orderQueryVo.setStartNum(startNum);
        orderQueryVo.setPageNo(pageNum);
        orderQueryVo.setPageSize(pageSize);
    }

    @Transactional
    public boolean updateAndSaveUserInfo(User user, ScoreInfo scoreInfo) {
        //1、更新用户信息
        int count = usersMapper.edit(user);
        if (count == 0) {
            return false;
        }

        //2、保存用户成绩信息
        int save = scoreInfoMapper.add(scoreInfo);
        if (save == 0) {
            return false;
        }

        return true;
    }
}
