package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.expection.BaseException;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.SchemeMapper;
import cn.wisenergy.mapper.VolunteerMapper;
import cn.wisenergy.model.app.SchemeInfo;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.service.app.VolunteerService;
import cn.wisenergy.service.common.VolunteerListener;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;

/**
 * @ Description: 志愿接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/8 9:44
 */
@Service
@Slf4j
public class VolunteerServiceImpl extends ServiceImpl<VolunteerMapper, Volunteer> implements VolunteerService {
    @Autowired
    private VolunteerMapper volunteerMapper;

    @Autowired
    private SchemeMapper schemeMapper;

    @Override
    public R<Boolean> batchAdd(List<Volunteer> list) {
        return null;
    }

    @Override
    public void excelAdd(MultipartFile file, Integer type, String schemeName, HttpServletResponse response) throws IOException {

        //判断文件类型=
        boolean valid = this.validContentType(file.getOriginalFilename());
        if (!valid) {
            throw new BaseException("请传入Excel文件");
        }

        //1、保存方案信息
        SchemeInfo schemeInfo = new SchemeInfo();
        schemeInfo.setSchemeName(schemeName);
        schemeInfo.setType(type);
        schemeInfo.setUploadTime(new Date());
        schemeInfo.setIsDelete(0);

        saveSchemeAndVolunteer(schemeInfo,file);
    }

    /**
     * 保存方案和志愿信息
     *
     * @param schemeInfo 方案信息
     * @param file       志愿文件
     * @throws IOException 异常
     */
    @Transactional(rollbackFor =Exception.class )
    public void saveSchemeAndVolunteer(SchemeInfo schemeInfo, MultipartFile file) throws IOException {

        //1、保存方案信息
        int count = schemeMapper.add(schemeInfo);
        if (count == 0) {
            throw new RuntimeException("保存方案信息失败!");
        }

        //2.读取数据进行入库操作
        EasyExcel.read(file.getInputStream(), Volunteer.class, new VolunteerListener(this)).sheet().doRead();
    }

    /**
     * 判断文件类型
     *
     * @param fileName 文件名
     * @return true or false
     */
    public boolean validContentType(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return false;
        }
        String substring = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (substring.equals("xlsx") || substring.equals("xls")) {
            return true;
        }
        return false;
    }
}
