package cn.wisenergy.service.cache;

import java.util.Collection;
import java.util.Map;

/**
 * @author 86187
 */
public interface Cache<T> {
    /**
     * Get an item from the cache, nontransactionally
     * @param key
     * @return the cached object or <tt>null</tt>
     */
    Object get(Object key);

    /**
     * 批量set
     * @param map
     */
    void multiSet(Map map);


    /**
     * 批量删除
     * @param keys 要删除的key集合
     */
    void multiDel(Collection keys);

    /**
     * Add an item to the cache, nontransactionally, with
     * failfast semantics
     * @param key
     * @param value
     */
    void put(Object key, T value);

    /**
     * 往缓存中写入内容
     * @param key
     * @param value
     * @param exp 超时时间，单位为秒
     */
    void put(Object key, T value, long exp);
    /**
     * 删除
     * @param key
     */
    void remove(Object key);

    /**
     * 删除
     * @param key
     */
    void vagueDel(Object key);

    /**
     * Clear the cache
     */
    void clear();

}
