package cn.wisenergy.service.cache;

import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * @author 86187
 * @ Description: redis的cache实现
 * @ Author     : 86187
 * @ Date       : 2021/1/18 11:03
 */
@Component
public class RedisCacheImpl implements Cache<T> {

    @Autowired
    private RedisTemplate redisTemplate;


    public RedisCacheImpl() {

    }


    @Override
    public Object get(Object key) {
        return redisTemplate.opsForValue().get(key);
    }

    @Override
    public void multiSet(Map map) {
        redisTemplate.opsForValue().multiSet(map);
    }

    @Override
    public void multiDel(Collection keys) {
        redisTemplate.delete(keys);
    }

    @Override
    public void put(Object key, T value) {
        redisTemplate.opsForValue().set(key, value);
    }

    @Override
    public void put(Object key, T value, long exp) {
        redisTemplate.opsForValue().set(key, value, exp, TimeUnit.SECONDS);
    }


    @Override
    public void remove(Object key) {

        redisTemplate.delete(key);
    }

    /**
     * 删除
     *
     * @param key
     */
    @Override
    public void vagueDel(Object key) {
        Set<String> keys = redisTemplate.keys(key + "*");
        redisTemplate.delete(keys);
    }

    @Override
    public void clear() {

        Set keys = redisTemplate.keys("*");
        redisTemplate.delete(keys);
    }

}
