/*
package com.project.shiro.controller;

import BASE_RESP_CODE_ENUM;
import BaseCustomException;
import Result;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

*/
/**
 * 控制器基类
 *
 * @author wyy
 * @date 2019年0月14日
 *//*

public abstract class BaseController {
    private static final long serialVersionUID = -6344078923170236539L;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    */
/**
     * 应用接口异常处理
     *
     * @param response Response相应对象
     * @param ex
     *//*

    @ResponseBody
    @ExceptionHandler(Exception.class)
    public void handleException(HttpServletResponse response, Exception ex) {
        Class eClass = ex.getClass();
        Map<String, Object> map = new HashMap<>();
        */
/*map.put(Result.RESULT_FLG.valueOf(), ResultUtil.Result.FAIL.getValue());*//*

        if (!eClass.equals(BaseCustomException.class)) {
            log.error(ExceptionUtils.getStackTrace(ex));
        }
        //以下异常中，除注释过的，其他异常可不关注
        if (eClass.equals(MissingServletRequestParameterException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.MIS_REQ_PARAM, map);
        } else if (eClass.equals(TypeMismatchException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.MIS_REQ_PARAM, map);
        } else if (eClass.equals(HttpMessageNotReadableException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.MIS_REQ_PARAM, map);
        } else if (eClass.equals(HttpRequestMethodNotSupportedException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.METHOD_NOT_SUPPORTED, map);
        } else if (eClass.equals(HttpMediaTypeNotAcceptableException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.MEDIA_TYPE_NOT_ACCEPT, map);
        } else if (eClass.equals(HttpMediaTypeNotSupportedException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.MEDIA_TYPE_NOT_SUPPORTED, map);
        } else if (eClass.equals(ConversionNotSupportedException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.SERVER_ERROR, map);
        } else if (eClass.equals(HttpMessageNotWritableException.class)) {
            addResCodeToMap(BASE_RESP_CODE_ENUM.SERVER_ERROR, map);
        } else if (eClass.equals(BaseCustomException.class)) { //系统业务异常
            addExceptionToMap((BaseCustomException) ex, map);
        } else if (eClass.equals(UnauthorizedException.class)) { // 无权限
            addExceptionToMap(new BaseCustomException(BASE_RESP_CODE_ENUM.REJECT_REQUEST), map);
        } else {
            addResCodeToMap(BASE_RESP_CODE_ENUM.SERVER_ERROR, map);
        }

        // 错误相应编码回写
        PrintWriter writer = null;
        try {
            response.setContentType("application/json; charset=UTF-8");
            writer = response.getWriter();
            writer.write(JSONObject.fromObject(map).toString());
            writer.flush();
        } catch (Exception e) {
            IOUtils.closeQuietly(writer);
            log.error("接口异常:{}", ExceptionUtils.getFullStackTrace(e));
        }
    }

    */
/**
     * 添加系统异常信息到map中
     *
     * @param responseCodeEnum 错误响应编码枚举类对象
     * @param map              响应错误编码集合
     *//*

    protected void addResCodeToMap(BASE_RESP_CODE_ENUM responseCodeEnum, Map<String, Object> map) {
        map.put(ResultUtil.ERRORCODE_PARAM_NAME, responseCodeEnum.getCode());
        map.put(ResultUtil.ERRORMSG_PARAM_NAME, responseCodeEnum.getMsg());
    }

    */
/**
     * 添加异常信息到map中
     *
     * @param baseCustomException 接口异常类
     * @param map                 接口异常集合
     *//*

    protected void addExceptionToMap(BaseCustomException baseCustomException, Map<String, Object> map) {
        map.put(ResultUtil.ERRORCODE_PARAM_NAME, baseCustomException.getErrorCode());
        map.put(ResultUtil.ERRORMSG_PARAM_NAME, baseCustomException.getErrorMsg());
    }

    */
/**
     * 添加数据到结果对象中
     *
     * @param obj 封装接口集合参数
     * @return
     *//*

    public Map<String, Object> getResult(Object obj) {
        Map<String, Object> map = new HashMap<>();
        map.put(ResultUtil.RESULT_PARAM_NAME, ResultUtil.Result.SUCCESS.getValue());
        map.put(ResultUtil.DATA_PARAM_NAME, obj);
        return map;
    }
}
*/
