package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Profession;
import cn.wisenergy.service.app.ProfessionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ Description: 用户管理模
 * @ Author     : 86187
 * @ Date       : 2021/1/13 10:29
 */
@RestController
@Api(tags = "专业管理")
@RequestMapping("/profession")
@Slf4j
public class ProfessionController {
    @Autowired
    private ProfessionService professionService;

    @ApiOperation(value = "获取专业树结构", notes = "获取专业树结构", httpMethod = "GET")
    @GetMapping("/getTree")
    public R<List<Profession>> getTree(){
        return professionService.getTree();
    }
}
