package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.RefillCard;
import cn.wisenergy.model.dto.RefillCardDto;
import cn.wisenergy.service.app.RefillCardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "充值卡管理")
@RestController
@RequestMapping("/refillCard")
@Slf4j
public class RefillCardController {

    @Autowired
    private RefillCardService refillCardService;

    @ApiOperation(value = "充值卡管理",notes = "充值卡管理",httpMethod = "POST")
    @ApiImplicitParam(name = "numbers",value = "卡的数量",dataType="int",required = true)
    @PostMapping("/manage")
    public R<Boolean> manage(Integer numbers){
        log.info("RefillCardController[].manage[].input.param,numbers"+numbers);

        //创建对象参数
        RefillCard refillCard = new RefillCard();
        refillCard.setCardNumber(numbers);
        return  refillCardService.add(refillCard);
    }

    @ApiOperation(value = "激活充值卡",notes = "激活充值卡",httpMethod = "POST")
    @ApiImplicitParam(name = "batchNumber",value = "批次号",dataType = "string",required = true)
    @PostMapping("/update")
    public R<Boolean> update(String batchNumber){
        log.info("RefillCardController[].manage[].input.param,batchNumber"+batchNumber);
        return refillCardService.update(batchNumber);
    }

    @ApiOperation(value = "充值卡查询",notes = "充值卡查询",httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo",value = "页数",dataType="int"),
            @ApiImplicitParam(name = "pageSize",value = "每页显示条数",dataType="int")
    })
    @GetMapping("/select")
    public R<List<RefillCardDto>> select(Integer pageNo,Integer pageSize){
        log.info("RefillCardController[].select[].input.param.parampageNo,pageSize"+pageNo,pageSize);
        return refillCardService.getList(pageNo, pageSize);
    }
}
