package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.UserLimit;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.service.app.UserLimitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ Description: PC-用户查询次数
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-用户查询次数")
@RequestMapping("/user/limit")
@Slf4j
public class UserLimitController {

    @Autowired
    private UserLimitService userLimitService;

    @ApiOperation(value = "获取用户查询次数", notes = "获取用户查询次数", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "int", required = true)
    @GetMapping("/getByUserId")
    public R<UserLimit> getByUserId(Integer userId) {
        log.info("volunteer-service[]UserLimitController[]getVolunteerList[]input.param.userId:" + userId);
        if (null == userId ) {
            return R.error("入参为空!");
        }

        return userLimitService.getByUserId(userId);
    }
}
