package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.Banner;
import cn.wisenergy.model.vo.UpdatePasswordVo;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserLoginVo;
import cn.wisenergy.model.vo.UserRegisterVo;
import cn.wisenergy.service.app.UserLoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ Description: PC-用户登录
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-用户登录")
@RequestMapping("/user/login")
@Slf4j
public class UserLoginController {

    @Autowired
    private UserLoginService userLoginService;

    @ApiOperation(value = "用户注册", notes = "用户注册", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户信息", dataType = "UserRegisterVo")
    @PostMapping("/register")
    public R<Boolean> resetPassword(@RequestBody UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userVo:" + userVo);

        if (null == userVo) {
            return R.error("入参为空!");
        }

        if (StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.register(userVo);
    }

    @ApiOperation(value = "用户验证码登录", notes = "用户验证码登录", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户信息", dataType = "UserLoginVo")
    @PostMapping("/loginCode")
    public R<Boolean> loginCode(@RequestBody UserLoginVo userVo) {
        log.info("volunteer-service[]UserLongController[]loginCode[]input.param.userVo:" + userVo);

        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getCode()) ||
                StringUtils.isBlank(userVo.getType()) || null == userVo.getScene()) {
            return R.error("入参为空!");
        }

        return userLoginService.loginCode(userVo);
    }

    @ApiOperation(value = "用户账号密码登录", notes = "用户账号密码登录", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "登录用户信息", dataType = "UserLoginVo")
    @PostMapping("/login")
    public R<UserInfoVo> login(@RequestBody UserLoginVo userVo) {
        log.info("volunteer-service[]UserLongController[]login[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.login(userVo);
    }


    @ApiOperation(value = "退出登录", notes = "退出登录", httpMethod = "POST")
    @PostMapping("/loginOut")
    public R<Boolean> loginOut(Integer userId) {
        log.info("volunteer-service[]UserLongController[]loginOut[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        return userLoginService.loginOut(userId);
    }

    @ApiOperation(value = "修改用户密码", notes = "修改用户密码", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户密码", dataType = "UpdatePasswordVo")
    @PostMapping("/updatePassword")
    public R<Boolean> updatePassword(@RequestBody UpdatePasswordVo userVo) {
        log.info("volunteer-service[]UserLongController[]updatePassword[]input.param.userVo:" + userVo);
        if (null == userVo || null == userVo.getUserId() || StringUtils.isBlank(userVo.getOldPassword()) ||
                StringUtils.isBlank(userVo.getNewPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.updatePassword(userVo);
    }

    @ApiOperation(value = "重置密码", notes = "重置密码", httpMethod = "POST")
    @PostMapping("/resetPassword")
    public R<Boolean> resetPassword(Integer userId) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        return userLoginService.resetPassword(userId);
    }

    @ApiOperation(value = "短信重置密码", notes = "修改用户密码", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户密码", dataType = "UserLoginVo")
    @PostMapping("/smsResetPassword")
    public R<Boolean> smsResetPassword(@RequestBody UserLoginVo userVo) {
        log.info("volunteer-service[]UserLongController[]smsResetPassword[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) ||
                StringUtils.isBlank(userVo.getPassword()) || null == userVo.getScene()) {
            return R.error("入参不能为空!");
        }

        return userLoginService.smsResetPassword(userVo);
    }
}
