package cn.wisenergy.common.utils.exportView.view;

import org.springframework.web.servlet.view.AbstractView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/**
 * pdf视图
 * Created by yqh on 2017/2/13.
 */
public class PdfView extends AbstractView {

    private String filename;

    public PdfView(String filename) {
        super();
        this.setContentType("application/pdf");
        this.filename = filename;
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (filename != null) {
            OutputStream os = httpServletResponse.getOutputStream();
            InputStream is = new FileInputStream(filename);
            int len = -1;
            byte[] arr = new byte[1024];
            while ((len = is.read(arr)) != -1) {
                os.write(arr, 0, len);
            }
            is.close();
        }
    }
}
