package cn.wisenergy.mapper;

import cn.wisenergy.model.app.UserInfo;
import cn.wisenergy.model.dto.UserInfoDto;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *@ Description:
 *@ Author     : 86187
 *@ Date       : 2021/1/6 15:32
 */
@Mapper
public interface UsersMapper extends BaseMapper<UserInfo> {
    /**
     * 添加
     * @param userInfo 用户信息
     * @return 用户信息
     */
    UserInfo add(UserInfo userInfo);

    /**
     * 编辑
     * @param userInfo 用户信息
     * @return 修改是否成功
     */
    int edit(UserInfo userInfo);

    /**
     * 删除
     * @param id 用户id
     * @return 删除是否成功
     */
    int delById(@Param("id") Integer id);

    int countByPhoneAnsUserId(@Param("phone") String phone, @Param("userId") Integer userId);

    List<UserInfo> getList(Map<String,Object> map);

    Integer getUserNumbers();
}
