package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 86187
 * @ Description   :  用户实体类
 * @ Author        :  lcc
 * @ CreateDate    :  2020/11/8 19:59
 */
@Data
@ApiModel(value = "AccountUsers")
public class UserInfo extends BaseEntity implements Serializable {
    private static final long serialVersionUID = 2525339404301884673L;

    /**
     * 主键id
     */
    @ApiModelProperty(name ="id",value = "用户主键id")
    private Integer id;

    /**
     * 用户名称
     */
    @ApiModelProperty(name = "name",value = "用户名")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(name="password",value = "用户密码")
    private String password;

    /**
     * 电话号码
     */
    @ApiModelProperty(name = "phone",value = "手机号")
    private String phone;

    /**
     * 头像
     */
    @ApiModelProperty(name = "headImage",value = "头像")
    private String headImage;

    /**
     * 性别
     */
    @ApiModelProperty(name = "sex",value = "用户性别:0:男，1：女")
    private Integer sex;

    /**
     * 学校
     */
    @ApiModelProperty(name = "school", value = "毕业院校")
    private String school;

    /**
     * 学生类型
     */
    @ApiModelProperty(name = "examType",value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生")
    private Integer studentType;

    /**
     * 用户剩余查询次数
     */
    @ApiModelProperty(name = "queryLimit",value = "用户剩余查询次数")
    private Integer queryLimit;

    /**
     * 用户充值总额
     */
    @ApiModelProperty(name = "moneyAmount",value = "充值总额")
    private String moneyAmount;
    /**
     * 是否删除
     */
    @ApiModelProperty(name = "isDelete",value = "是否删除 0：正常 1：删除")
    private Integer isDelete;
    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime",value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime",value = "修改时间")
    private Date updateTime;

}
