package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 用户分页查询Vo
*@ Author     : 86187
*@ Date       : 2021/1/7 11:30
*/
@Data
@ApiModel(value = "UserQueryVo")
public class UserQueryVo implements Serializable {
    private static final long serialVersionUID = -3717746916267660740L;

    /**
     * 关键词
     */
    @ApiModelProperty(value = "关键词", name = "keyword")
    private String keyword;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间", name = "startTime")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间", name = "endTime")
    private Date endTime;

    /**
     * 起始页
     */
    @ApiModelProperty(value = "起始页", name = "pageNo")
    private Integer pageNo;

    /**
     * 页大小
     */
    @ApiModelProperty(value = "页大小", name = "pageSize")
    private Integer pageSize;

    private Integer startNum;

    private Integer endNum;
}
