package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserRegisterVo;

/**
 * @ Description: 用户登录
 * @ Author     : 86187
 * @ Date       : 2021/1/7 14:20
 */
public interface UserLoginService {
    /**
     * 用户注册接口
     *
     * @param userRegisterVo    用户信息
     * @return true 成功 false 失败
     */
    R<Boolean> register(UserRegisterVo userRegisterVo);

    /**
     * 手机验证码登录
     *
     * @param code  验证码
     * @param phone 手机号
     * @return true 成功 false 失败
     */
    R<Boolean> loginCode(String code, String phone);

    /**
     * 手机-密码登录
     *
     * @param phone    手机号
     * @param password 密码
     * @return true 成功 false 失败
     */
    R<UserInfoVo> login(String phone, String password);

    /**
     * 退出登录
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> loginOut(Integer userId);

    /**
     * 修改密码
     *
     * @param userId      用户id
     * @param newPassword 新密码
     * @param oldPassword 旧密码
     * @return true 成功 false 失败
     */
    R<Boolean> updatePassword(Integer userId, String newPassword, String oldPassword);

    /**
     * 重置密码
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> resetPassword(Integer userId);

    /**
     * 短信重置密码
     *
     * @param code 用户id
     * @param phone    手机号
     * @return true 成功 false 失败
     */
    R<Boolean> notePassword(Integer code, String phone);
}
