package cn.wisenergy.service.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.UserInfo;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.model.vo.UserShowVo;
import com.github.pagehelper.PageInfo;

/**
 * @ Description: 用户接口
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:08
 */
public interface UserService {


    /**
     * 获取用户列表
     *
     * @param queryVo 查询条件
     * @return 用户列表集合
     */
    R<PageInfo<UserInfoDto>> getUserList(UserQueryVo queryVo);

    /**
     * 提交个人信息
     *
     * @param userInfo 用户信息
     * @return 用户信息
     */
    R<UserInfoVo> commitUserInfo(UserCommitDto userInfo);

    /**
     * 编辑用户信息
     *
     * @param userInfo 用户信息
     * @return true 成功 false 失败
     */
    R<Boolean> edit(UserInfo userInfo);

    /**
     * 删除用户
     *
     * @param userId 用户id
     * @return true 成功 false 失败
     */
    R<Boolean> delete(Integer userId);

    /**
     * 获取用户信息
     *
     * @param id 用户id
     * @return 用户信息
     */
    R<UserShowVo> getById(Integer id);

}
