package cn.wisenergy.service.app.impl;

import cn.wisenergy.service.app.Daosupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class DaoSupportImpl implements Daosupport {

    private JdbcTemplate jdbcTemplate;

    /**
     * 日志记录
     */
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 实例化jdbcTemplate
     */
    public DaoSupportImpl(JdbcTemplate jdbcTemplate){
        this.jdbcTemplate= jdbcTemplate;
    }

    @Override
    public Integer queryForInt(String sql, Object... args) {
        try {
            Integer value = jdbcTemplate.queryForObject(sql, Integer.class, args);
            return  value==null?0:value;
        }catch(EmptyResultDataAccessException e){
            return 0;
        } catch (RuntimeException e) {
            this.logger.error(e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> clazz, Object... args) {

        return this.jdbcTemplate.query(sql, new BeanPropertyRowMapper<T>(clazz), args);

    }
}
