package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.LoginRecord;
import cn.wisenergy.model.app.UserInfo;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserRegisterVo;
import cn.wisenergy.service.app.UserLoginService;
import cn.wisenergy.service.common.Common;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ Description: 用户登录相关接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/7 14:22
 */
@Service
@Slf4j
public class UserLoginServiceImpl extends ServiceImpl<UsersMapper, UserInfo> implements UserLoginService {
    @Autowired
    private UsersMapper usersMapper;

    @Override
    public R<Boolean> register(UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLoginServiceImpl[]register[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) ||
                StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参为空!");
        }

        String phone = userVo.getPhone();
        String password = userVo.getPassword();

        //1.检查号码是否重复
        Integer userId = null;
        Boolean bool = checkPhone(phone, userId);
        if (!bool) {
            return R.error("该电话号码" + phone + "已被使用!");
        }

        //2、给密码加密 加密规则，电话号码+明文密码
        String secret = Md5Util.digestMD5(phone + password);

        //3、添加用户信息
        UserInfo userInfo = new UserInfo();
        userInfo.setPhone(phone);
        userInfo.setPassword(secret);

        UserInfo user = usersMapper.add(userInfo);
        if (null == user) {
            return R.ok(1, false);
        }

        //4、保存操作记录
        LoginRecord loginRecord=new LoginRecord();
        loginRecord.setType(1);

        return R.ok(0, true);
    }

    @Override
    public R<Boolean> loginCode(String code, String phone) {
        return null;
    }

    @Override
    public R<UserInfoVo> login(String phone, String password) {
        log.info("volunteer-service[]UserLoginServiceImpl[]login[]input.param.phone,password:" + phone, password);
        if (StringUtils.isBlank(phone) || StringUtils.isBlank(password)) {
            return R.error("入参为空!");
        }

        //1、根据手机号，获取用户信息
        QueryWrapper<UserInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", phone);
        queryWrapper.eq("is_delete", 0);
        UserInfo userInfo = usersMapper.selectOne(queryWrapper);
        if (null == userInfo) {
            return R.error("该用户不存在，请您注册账号!");
        }

        //2、判断密码是否正确
        //MD5加密
        String secret = Md5Util.digestMD5(phone + password);

        if (!userInfo.getPassword().equals(secret)) {
            return R.error("密码错误，请您输入正确密码!");
        }

        //3、构造返回参数
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUserId(userInfo.getId());
        userInfoVo.setUserName(userInfo.getUserName());
        userInfoVo.setPhone(userInfo.getPhone());
        return R.ok(userInfoVo);
    }

    @Override
    public R<Boolean> loginOut(Integer userId) {
        return null;
    }

    @Override
    public R<Boolean> updatePassword(Integer userId, String newPassword, String oldPassword) {
        return null;
    }

    @Override
    public R<Boolean> resetPassword(Integer userId) {
        log.info("volunteer-service[]UserLoginServiceImpl[]resetPassword[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参为空!");
        }

        //获取用户信息
        UserInfo userInfo = usersMapper.selectById(userId);

        //加密重置密码
        String password = Md5Util.digestMD5(Common.RESET_PASSWORD_VALUE);
        userInfo.setPassword(password);

        int count = usersMapper.edit(userInfo);
        if (count == 0) {
            return R.ok(1, false);
        }
        return R.ok(0, true);
    }

    @Override
    public R<Boolean> notePassword(Integer code, String phone) {
        return null;
    }

    private Boolean checkPhone(String phone, Integer userId) {
        //判断是注册还是编辑
        //1、注册-新增
        if (null == userId) {
            //根据电话号码查询用户
            QueryWrapper<UserInfo> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("phone", phone);
            queryWrapper.eq("is_delete", 0);
            UserInfo userInfo = usersMapper.selectOne(queryWrapper);
            if (null != userInfo) {
                return false;
            }
        }

        //2、编辑
        if (null != userId) {
            //根据电话号码和用户id,统计号码是否重复
            int count = usersMapper.countByPhoneAnsUserId(phone, userId);
            if (count > 0) {
                return false;
            }
        }

        return true;
    }



}
