package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.Md5Util;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.ScoreInfoMapper;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.ScoreInfo;
import cn.wisenergy.model.app.UserInfo;
import cn.wisenergy.model.dto.UserCommitDto;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.UserInfoVo;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.model.vo.UserShowVo;
import cn.wisenergy.service.app.UserService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @ Description: 用户接口实现
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:11
 */
@Service
@Slf4j
public class UserServiceImpl extends ServiceImpl<UsersMapper, UserInfo> implements UserService {

    @Autowired
    private UsersMapper usersMapper;

    @Autowired
    private ScoreInfoMapper scoreInfoMapper;

    @Override
    public R<PageInfo<UserInfoDto>> getUserList(UserQueryVo queryVo) {
        log.info("volunteer_service[]UserServiceImpl[]getUserList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参不能为空!");
        }
        pageHandle(queryVo);
        //创建参数容器
        HashMap<String, Object> map = new HashMap<>(4);
        //将参数放入容器中
        map.put("userQueryVo",queryVo);
        //查询用户数据
        List<UserInfo> list1 = usersMapper.getList(map);
        int total = 0;
        List<UserInfoDto> list = new ArrayList<>();
        //将集合遍历拿出用户id查询成绩信息
        for (UserInfo userInfo : list1) {
            //创建UserInfoDto返回对象
            UserInfoDto userInfoDto = new UserInfoDto();
            //查询成绩信息
            ScoreInfo scoreInfo = scoreInfoMapper.getById(userInfo.getId());
            //将消息进行同步
            BeanUtils.copyProperties(userInfo,userInfoDto);
            userInfoDto.setCultureGrade(scoreInfo.getCultureGrade());
            userInfoDto.setMajorGrade(scoreInfo.getMajorGrade());
            userInfoDto.setRegisterTime(userInfo.getCreateTime());
            //将userInfoDto装入集合中
            list.add(userInfoDto);
            //统计数据总量
            total+=1;
        }
        System.out.println(total+"  "+list1);
        PageInfo<UserInfoDto> info = new PageInfo<>();
        info.setPageSize(queryVo.getPageSize());
        info.setPageNum(queryVo.getPageNo());
        info.setTotal(total);
        info.setList(list);
        return R.ok(info);
    }

    @Override
    public R<UserInfoVo> commitUserInfo(UserCommitDto userInfo) {
        log.info("volunteer-service[]UserServiceImpl[]commitUserInfo[]input.param.userInfo:" + userInfo);
        if (null == userInfo) {
            return R.error("入参为空!");
        }

        //1、根据用户id,获取用户信息
        UserInfo user = usersMapper.selectById(userInfo.getId());
        if (null == user) {
            return R.error("用户信息不存在!");
        }

        //2、要提交的用户信息
        user.setSchool(userInfo.getSchool());
        user.setSex(userInfo.getSex());
        user.setStudentType(userInfo.getStudentType());
        user.setUserName(userInfo.getUserName());
        user.setIsDelete(0);

        //3、要提交的用户的成绩信息
        ScoreInfo scoreInfo = userInfo.getScoreInfo();

        //4、更新用户信息和保存用户成绩
        boolean bool = updateAndSaveUserInfo(user, scoreInfo);
        if (!bool) {
            return R.error("添加用户信息失败!");
        }

        //返回信息
        UserInfoVo userInfoVo = new UserInfoVo();
        userInfoVo.setUserId(userInfo.getId());
        userInfoVo.setUserName(userInfo.getUserName());
        userInfoVo.setPhone(user.getPhone());
        userInfoVo.setSex(userInfo.getSex());
        userInfoVo.setStudentType(userInfo.getStudentType());
        userInfoVo.setUserName(userInfo.getUserName());
        return R.ok(userInfoVo);
    }

    @Override
    public R<Boolean> edit(UserInfo userInfo) {
        return null;
    }

    @Override
    public R<Boolean> delete(Integer userId) {
        return null;
    }

    @Override
    public R<UserShowVo> getById(Integer id) {
        log.info("volunteer-service[]UserServiceImpl[]getById[]input.param.id:" + id);
        if (null == id) {
            return R.error("入参为空!");
        }

        //根据id,获取用户信息
        UserInfo userInfo = usersMapper.selectById(id);
        if (null == userInfo) {
            return R.error("用户信息不存在!");
        }

        UserShowVo userShowVo = new UserShowVo();
        userShowVo.setId(userInfo.getId());
        userShowVo.setSchool(userInfo.getSchool());
        userShowVo.setSex(userInfo.getSex());
        userShowVo.setStudentType(userInfo.getStudentType());
        userShowVo.setUserName(userInfo.getUserName());

        //获取成绩信息
        QueryWrapper<ScoreInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userInfo.getId());
        ScoreInfo scoreInfo = scoreInfoMapper.selectOne(queryWrapper);
        if (null != scoreInfo) {
            userShowVo.setScoreInfo(scoreInfo);
        }
        return R.ok(userShowVo);
    }

    /**
     * 分页处理方法
     *
     * @param orderQueryVo 参数
     */
    private void pageHandle(UserQueryVo orderQueryVo) {
        Integer pageNum = orderQueryVo.getPageNo();
        Integer pageSize = orderQueryVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        orderQueryVo.setEndNum(endNum);
        orderQueryVo.setStartNum(startNum);
        orderQueryVo.setPageNo(pageNum);
        orderQueryVo.setPageSize(pageSize);
    }

    @Transactional
    public boolean updateAndSaveUserInfo(UserInfo userInfo, ScoreInfo scoreInfo) {
        //1、更新用户信息
        int count = usersMapper.edit(userInfo);
        if (count == 0) {
            return false;
        }

        //2、保存用户成绩信息
        int save = scoreInfoMapper.add(scoreInfo);
        if (save == 0) {
            return false;
        }

        return true;
    }
}
