package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.AccountDto;
import cn.wisenergy.service.app.AccountSerivce;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 */
@Api(tags = "管理员登录")
@RestController
@RequestMapping("/account")
@Slf4j
public class AccountController {
    @Autowired
    private AccountSerivce accountSerivce;

    @ApiOperation(value = "管理员登录",notes = "管理员登录",httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userName",value = "账号",required = true),
            @ApiImplicitParam(name = "password",value = "密码",required = true)
    })
    @PostMapping("/login")
    public R<AccountDto> getAccountInfo(String userName, String password){
        log.info("AccountController[].getAccountInfo[].input.param:userName,password"+userName,password);
        //判断参数是否为空
        if (StringUtils.isEmpty(userName)||StringUtils.isEmpty(password)) {
            return R.error("账号或密码为空");
        }
        //查询管理员信息
        //返回数据
        return accountSerivce.getAccountInfo(userName, password);
    }
}
