package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.PayRecord;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.model.vo.PayRecordQueryVo;
import cn.wisenergy.model.vo.PayRecordShowVo;
import cn.wisenergy.service.app.PayRecordService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @ Description: PC-我的账户
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:45
 */
@RestController
@Api(tags = "PC-我的账户")
@RequestMapping("/pay/record")
@Slf4j
public class PayRecordController {

    @Autowired
    private PayRecordService payRecordService;

    @ApiOperation(value = "保存充值记录", notes = "保存充值记录", httpMethod = "POST")
    @ApiImplicitParam(name = "payRecord", value = "充值记录信息", dataType = "PayRecord")
    @PostMapping("/add")
    public R<Boolean> add(@RequestBody PayRecord payRecord) {
        log.info("volunteer-service[]PayRecordController[]add[]input.param.payRecord:" + payRecord);
        if (null == payRecord) {
            return R.error("入参为空!");
        }

        return payRecordService.add(payRecord);
    }

    @ApiOperation(value = "获取充值记录列表", notes = "获取充值记录列表", httpMethod = "GET")
    @ApiImplicitParam(name = "payVo", value = "充值记录查询参数", dataType = "PayRecord")
    @GetMapping("/getList")
    public R<PageInfo<PayRecordShowVo>> getList(@RequestBody PayRecordQueryVo payVo) {
        log.info("volunteer-service[]PayRecordController[]getList[]input.param.payVo:" + payVo);
        if (null == payVo) {
            return R.error("入参为空!");
        }

        return payRecordService.getList(payVo);
    }

}
