package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.SchemeQueryRecord;
import cn.wisenergy.model.vo.SchemeQueryVo;
import cn.wisenergy.model.vo.SchemeRecordQueryVo;
import cn.wisenergy.model.vo.VolunteerVo;
import cn.wisenergy.service.app.SchemeService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ Description: PC-方案
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-方案")
@RequestMapping("/scheme")
@Slf4j
public class SchemeController {

    @Autowired
    private SchemeService schemeService;

    @ApiOperation(value = "获取志愿列表", notes = "获取志愿列表", httpMethod = "GET")
    @ApiImplicitParam(name = "queryVo", value = "志愿查询参数", dataType = "SchemeQueryVo")
    @GetMapping("/getList")
    public R<VolunteerVo> getList(@RequestBody SchemeQueryVo queryVo) {
        log.info("volunteer-service[]SchemeController[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参为空!");
        }

        return schemeService.getList(queryVo);
    }

}
