package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.PayRecord;
import cn.wisenergy.model.app.SchemeQueryRecord;
import cn.wisenergy.model.app.Volunteer;
import cn.wisenergy.model.vo.PayRecordQueryVo;
import cn.wisenergy.model.vo.PayRecordShowVo;
import cn.wisenergy.model.vo.SchemeRecordQueryVo;
import cn.wisenergy.service.app.SchemeRecordService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ Description: PC-我的方案
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:48
 */
@RestController
@Api(tags = "PC-我的方案")
@RequestMapping("/scheme/record")
@Slf4j
public class SchemeRecordController {

    @Autowired
    private SchemeRecordService schemeRecordService;

    @ApiOperation(value = "保存方案查询记录", notes = "保存方案查询记录", httpMethod = "POST")
    @ApiImplicitParam(name = "query", value = "方案查询信息", dataType = "SchemeQueryRecord")
    @PostMapping("/add")
    public R<SchemeQueryRecord> add(@RequestBody SchemeQueryRecord query) {
        log.info("volunteer-service[]SchemeRecordController[]add[]input.param.query:" + query);
        if (null == query) {
            return R.error("入参为空!");
        }

        return schemeRecordService.add(query);
    }

    @ApiOperation(value = "获取方案查询记录列表", notes = "获取方案查询记录列表", httpMethod = "GET")
    @ApiImplicitParam(name = "queryVo", value = "方案查询记录参数", dataType = "SchemeRecordQueryVo")
    @GetMapping("/getList")
    public R<PageInfo<SchemeQueryRecord>> getList(SchemeRecordQueryVo queryVo) {
        log.info("volunteer-service[]SchemeRecordController[]getList[]input.param.queryVo:" + queryVo);
        if (null == queryVo) {
            return R.error("入参为空!");
        }

        return schemeRecordService.getList(queryVo);
    }

    @ApiOperation(value = "获取充值记录志愿列表", notes = "获取充值记录志愿列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "int", required = true),
            @ApiImplicitParam(name = "recordId", value = "记录id", dataType = "int", required = true)
    })
    @GetMapping("/getVolunteerList")
    public R<List<Volunteer>> getVolunteerList(Integer userId, Integer recordId) {
        log.info("volunteer-service[]SchemeRecordController[]getVolunteerList[]input.param.userId:{},recordId:" + userId, recordId);
        if (null == userId || null == recordId) {
            return R.error("入参为空!");
        }

        return schemeRecordService.getVolunteerList(userId, recordId);
    }
}
