package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.dto.UserInfoDto;
import cn.wisenergy.model.vo.UserQueryVo;
import cn.wisenergy.service.app.UserService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.net.InetAddress;

/**
 * @ Description: 用户管理模
 * @ Author     : 86187
 * @ Date       : 2021/1/7 10:29
 */
@RestController
@Api(tags = "用户管理")
@RequestMapping("/user")
@Slf4j
public class UserController {
      @Autowired
      private UserService userService;

      @ApiOperation(value = "用户管理",notes = "用户管理",httpMethod = "POST")
      @ApiImplicitParam(name = "queryVo", value = "用户信息", dataType = "UserQueryVo")
      @PostMapping("/manage")
      public R manageUser(UserQueryVo queryVo){
          log.info("UserController[].manageUser[].input.param:queryV0:{}"+queryVo);
          //查询用户信息
          R<PageInfo<UserInfoDto>> userList = userService.getUserList(queryVo);
          System.out.println(userList);
          if (null==userList||userList.getData().getList().size()==0) {
              return R.error("展时还没有用户");
          }
          //返回数据
          return R.ok(userList);
      }


}
