package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.UserRegisterVo;
import cn.wisenergy.service.app.UserLoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ Description: PC-用户登录
 * @ Author     : 86187
 * @ Date       : 2021/1/14 10:50
 */
@RestController
@Api(tags = "PC-用户登录")
@RequestMapping("/user/login")
@Slf4j
public class UserLongController {

    @Autowired
    private UserLoginService userLoginService;

    @ApiOperation(value = "用户注册", notes = "用户注册", httpMethod = "POST")
    @ApiImplicitParam(name = "userVo", value = "用户信息", dataType = "UserRegisterVo")
    @PostMapping("/register")
    public R<Boolean> resetPassword(@RequestBody UserRegisterVo userVo) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userVo:" + userVo);
        if (null == userVo || StringUtils.isBlank(userVo.getPhone()) || StringUtils.isBlank(userVo.getPassword())) {
            return R.error("入参不能为空!");
        }

        return userLoginService.register(userVo);
    }

    @ApiOperation(value = "重置密码", notes = "重置密码", httpMethod = "POST")
    @PostMapping("/resetPassword")
    public R<Boolean> resetPassword(Integer userId) {
        log.info("volunteer-service[]UserLongController[]resetPassword[]input.param.userId:" + userId);
        if (null == userId) {
            return R.error("入参不能为空!");
        }

        return userLoginService.resetPassword(userId);
    }
}
