package cn.wisenergy.common.utils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.http.HttpStatus;

import java.io.Serializable;

/**
 * 响应信息类
 *
 * @author lut
 */
@Data
@ApiModel(description = "响应信息主体")
public class R<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("返回标记：成功标记=0，失败标记1")
    private int code;
    @ApiModelProperty("返回信息")
    private String message;
    @ApiModelProperty("数据")
    private T data;

    public R() {
        this.code = 0;
        this.message = "success";
    }

    public R(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public R(int code, T data) {
        this.code = code;
        this.data = data;
    }

    public R(T data) {
        this.code = 0;
        this.message = "success";
        this.data = data;
    }

    public R(T data, String msg) {
        this.code = 0;
        this.data = data;
        this.message = msg;
    }

    public R(int code, String msg,T data) {
        this.code = code;
        this.data = data;
        this.message = msg;
    }

    /**
     * 请求成功
     */
    public static <T> R<T> ok() {
        return new R<>();
    }

    /**
     * 请求成功，返回前端的信息
     *
     * @param msg 描述
     * @return R
     */
    public static <T> R<T> ok(String msg, T data) {
        return new R<>(data, msg);
    }

    /**
     * 请求成功，返回前端的信息
     *
     * @param data 返回值
     * @return R
     */
    public static <T> R<T> ok(T data) {
        return new R<>(0, data);
    }

    /**
     * 请求成功，返回前端信息
     *
     * @param code 状态码
     * @param data 返回值
     * @return R
     */
    public static <T> R<T> ok(int code, T data) {
        return new R<>(code, data);
    }

    /**
     * 请求失败
     *
     * @return R
     */
    public static <T> R<T> error() {
        return new R<>(-1, "操作失败");
    }

    /**
     * 请求失败，返回前台信息
     *
     * @param msg 描述
     * @return R
     */
    public static <T> R<T> error(String msg) {
        return error(HttpStatus.SC_INTERNAL_SERVER_ERROR, msg);
    }

    /**
     * 请求失败，返回前台信息
     *
     * @param code 错误码
     * @param msg  描述
     * @return R
     */
    public static <T> R<T> error(int code, String msg) {
        return new R<>(code, msg);
    }

    /**
     * 请求失败，返回前台信息
     *
     * @param code 错误码
     * @param msg  描述
     * @return R
     */
    public static <T> R<T> error(int code, String msg,T data) {
        return new R<>(code, msg,data);
    }

}
