package cn.wisenergy.mapper;

import cn.wisenergy.model.app.CardInfo;
import cn.wisenergy.model.dto.ExportCardDto;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author 86187
 */
public interface CardMapper extends BaseMapper<CardInfo> {
    /**
     * 添加充值卡子卡
     *
     * @param cardInfos
     * @return
     */
    int add(List<CardInfo> cardInfos);

    /**
     * 编辑
     * @param cardInfo 信息
     * @return 结果
     */
    int edit(CardInfo cardInfo);

    /**
     * 根据密码获取充值卡信息
     *
     * @param secretKey 密码
     * @return 充值卡信息
     */
    CardInfo getBySecretKey(@Param("secretKey") String secretKey);

    /**
     * 通过批次号获取所有字卡
     * @param batchNumber 批次号
     * @return 子卡集合
     */
    List<CardInfo> getList(@Param("batchNumber")String batchNumber);
}
