package cn.wisenergy.mapper;

import cn.wisenergy.model.app.RefillCard;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface RefillCardMapper extends BaseMapper<RefillCardMapper> {

    /**
     * 添加充值卡
     * @param refillCard
     * @return
     */
    int add(RefillCard refillCard);

    /**
     * 改变激活状态
     * @param batchNumber
     * @return
     */
    int update(@Param("batchNumber") String batchNumber);

    /**
     * 获取充值卡信息
     * @param map
     * @return
     */
    List<RefillCard> getList(Map<String,Object> map);

    /**
     * 获取充值卡数量
     * @return
     */
    Integer getUserNumbers();

    /**
     * 通过ID查询充值卡信息
     * @param id 主键
     * @return 充值卡信息
     */
    RefillCard getById(@Param("id") Integer id);

    int setIsMakeCard(@Param("id") Integer id);

    /**
     * 通过批次号查询充值卡信息
     * @param batchNumber 批次号
     * @return 充值卡信息
     */
    RefillCard getByBatchNumber(@Param("batchNumber") String batchNumber);
}
