package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 录取规则实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/19 10:43
 */
@Data
@ApiModel(value = "AdmissionRule")
public class AdmissionRule extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -9211670648343824241L;

    /**
     * 录取规则id
     */
    @ApiModelProperty(value = "录取规则id", name = "id")
    private Integer id;

    /**
     * 方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批
     */
    @ApiModelProperty(value = "方案类型：1：本科文化一批 2：本科美术一批 3：艺术本科批文学编导 4：本科体育  " +
            "5：专科专业分类6：专科美术一批 7：专科文学编导一批 8：专科体育一批", name = "type")
    private Integer type;

    /**
     * 文化成绩最高分
     */
    @ApiModelProperty(value = "文化成绩最高分", name = "cultureMax")
    private Double cultureMax;

    /**
     * 文化成绩最低分
     */
    @ApiModelProperty(value = "文化成绩最低分", name = "cultureMin")
    private Double cultureMin;

    /**
     * 本年文化课录取线
     */
    @ApiModelProperty(value = "本年文化课录取线", name = "currentYearCulture")
    private Double currentYearCulture;

    /**
     * 专业成绩最高分
     */
    @ApiModelProperty(value = "专业成绩最高分", name = "professionMax")
    private Double professionMax;

    /**
     * 专业成绩最低分
     */
    @ApiModelProperty(value = "专业成绩最低分", name = "professionMin")
    private Double professionMin;

    /**
     * 本年专业课录取线
     */
    @ApiModelProperty(value = "本年文化课录取线", name = "currentYearMajor")
    private Double currentYearMajor;

    /**
     * 向上浮动分数
     */
    @ApiModelProperty(value = "向上浮动分数", name = "upMark")
    private Double upMark;

    /**
     * 向下浮动分数
     */
    @ApiModelProperty(value = "向下浮动分数", name = "downMark")
    private Double downMark;

    /**
     * 展示志愿总数
     */
    @ApiModelProperty(value = "展示志愿总数", name = "number")
    private Integer number;
}
