package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ Description: 广告实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/7 16:01
 */
@Data
@ApiModel(value = "Advertising")
public class Banner implements Serializable {

    private static final long serialVersionUID = 5513428780946937905L;

    /**
     *  广告id
     */
    @ApiModelProperty(value = "广告id",name = "id")
    private Integer id;

    /**
     * 合作公司名称
     */
    @ApiModelProperty(value = "合作公司名称",name = "companyName")
    private String companyName;

    /**
     * 投放状态 0：暂停中 1：投放中
     */
    @ApiModelProperty(value = "投放状态 0：暂停中 1：投放中",name = "status")
    private Integer status;

    /**
     * 网址
     */
    @ApiModelProperty(value = "网址",name = "website")
    private String website;

    /**
     * 是否有宣传图 0：没有 1：有
     */
    @ApiModelProperty(value = "是否有宣传图 0：没有 1：有",name = "isHaveImage")
    private Integer isHaveImage;

    /**
     * 广告类型： 1：顶部广告 2：底部广告
     */
    @ApiModelProperty(value = "广告类型： 1：顶部广告 2：底部广告",name = "type")
    private Integer type;

    /**
     * 广告图片url
     */
    @ApiModelProperty(value = "广告图片url",name = "image")
    private String image;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间",name = "updateTime")
    private Date updateTime;

    /**
     * 标题
     */
    @ApiModelProperty(value = "标题",name = "title")
    private String title;
}
