package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ Description: 方案查询记录
 * @ Author     : 86187
 * @ Date       : 2021/1/8 10:22
 * @author 86187
 */
@Data
@ApiModel(value = "SchemeQueryRecord")
@TableName("scheme_query_record")
public class SchemeQueryRecord implements Serializable {

    private static final long serialVersionUID = 6600452699328342752L;

    /**
     * 方案查询记录id
     */
    @ApiModelProperty(value = "方案查询记录id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 专业名称
     */
    @ApiModelProperty(value = "专业名称", name = "majorName")
    private String majorName;

    /**
     * 考生类型 1：本科
     */
    @ApiModelProperty(value = "考生类型 1：本科", name = "studentType")
    private Integer studentType;

    /**
     * 考生文化分数
     */
    @ApiModelProperty(value = "考生文化分数", name = "score")
    private String score;

    /**
     * 考生专业分数
     */
    @ApiModelProperty(value = "考生专业分数", name = "majorScore")
    private String majorScore;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;


    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 删除标记
     */
    @ApiModelProperty("是否删除 1,删除;0,未删除")
    private Integer isDelete;
}
