package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 86187
 * @ Description: 用户扣减查询次数记录实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/27 14:49
 */
@Data
@ApiModel("UserLimitRecord")
@TableName("user_limit_record")
public class UserLimitRecord implements Serializable {
    private static final long serialVersionUID = 6832626172862202016L;

    /**
     * 用户扣减查询次数记录id
     */
    @ApiModelProperty(value = "用户扣减查询次数记录id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户扣减查询次数记录id", name = "id")
    private Integer userId;

    /**
     * 用户查询信息id
     */
    @ApiModelProperty(value = "用户查询信息id", name = "userLimitId")
    private Integer userLimitId;

    /**
     * 扣减次数
     */
    @ApiModelProperty(value = "扣减次数", name = "minusLimit")
    private Integer minusLimit;

    /**
     * 扣减时间
     */
    @ApiModelProperty(value = "扣减时间", name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", name = "updateTime")
    private Date updateTime;
}
