package cn.wisenergy.model.common;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@JsonAutoDetect(creatorVisibility = JsonAutoDetect.Visibility.NONE, fieldVisibility = JsonAutoDetect.Visibility.NONE, getterVisibility = JsonAutoDetect.Visibility.NONE, isGetterVisibility = JsonAutoDetect.Visibility.NONE, setterVisibility = JsonAutoDetect.Visibility.NONE)
public abstract class BaseEntity implements Serializable {

	private static final long serialVersionUID = 7151370108706942192L;

	/**
	 * 创建时间
	 */
	@ApiModelProperty("创建时间")
	private Date createTime;


	/**
	 * 修改时间
	 */
	@ApiModelProperty("修改时间")
	private Date updateTime;

	/**
	 * 删除标记
	 */
	@ApiModelProperty("是否删除 1,删除;0,未删除")
	private Integer isDelete;

}
