package cn.wisenergy.model.dto;

import cn.wisenergy.model.app.ScoreInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("StaffAddDto")
public class StaffAddDto {
    private static final long serialVersionUID  = 1L;


    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    private String userName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex")
    private Integer sex;

    /**
     * 学校
     */
    @ApiModelProperty(value = "学校", name = "school")
    private String school;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "studentType")
    private Integer studentType;

    /**
     * 学生成绩信息
     */
    @ApiModelProperty(value = "学生成绩信息", name = "scoreInfo")
    private ScoreInfo scoreInfo;

    /**
     * vip客户电话
     */
    @ApiModelProperty(value = "vip客户电话", name = "VipMobile")
    private String VipMobile;
}

