package cn.wisenergy.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@ApiModel("StaffDto")
public class StaffDto implements Serializable {
    private static final long serialVersionUID = -7701107348928870362L;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "员工主键id")
    private Integer id;

    /**
     * 员工名称
     */
    @ApiModelProperty(name = "staffName",value = "员工名字")
    private String staffName;

    /**
     * 员工电话号码
     */

    @ApiModelProperty(name = "phone",value = "电话号码")
    private String phone;
    /**
     * 性别（0：男  1：女）
     */
    @ApiModelProperty(name = "sex", value = "性别（0：男  1：女）")
    private Integer sex;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间",name = "updateTime")
    private Date updateTime;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",name = "createTime")
    private Date createTime;

    /**
     * 是否禁用（0:正常  1：禁用）
     */
    @ApiModelProperty(name = "isDelete", value = "是否禁用（0:正常  1：禁用）")
    private Integer isDelete;
}
