package cn.wisenergy.model.enums;

/**
 * @author 86187
 * @ Description: 账户注册来源信息 枚举
 * @ Author     : 86187
 * @ Date       : 2021/2/9 10:48
 */
public enum SourceType {

    //PC
    PC(1, "PC"),

    h5(2, "h5"),

    Applet(3, "Applet");
    private Integer code;

    private String desc;

    SourceType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (SourceType type : SourceType.values()) {
            if (type.code.intValue() == code) {
                return type.getDesc();
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}
