package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 广告分页查询Vo
*@ Author     : 86187
*@ Date       : 2021/1/7 17:13
*/
@Data
@ApiModel(value = "AdvertisingQueryVo")
public class AdvertisingQueryVo implements Serializable {
    private static final long serialVersionUID = 8066049220539686367L;

    /**
     * 关键词
     */
    @ApiModelProperty(value = "关键词", name = "keyword")
    private String keyword;

    /**
     * 广告类型： 1：顶部广告 2：底部广告
     */
    @ApiModelProperty(value = "广告类型： 1：顶部广告 2：底部广告",name = "type")
    private Integer type;

    /**
     * 投放状态 0：暂停中 1：投放中
     */
    @ApiModelProperty(value = "投放状态 0：暂停中 1：投放中",name = "status")
    private Integer status;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "开始时间", name = "startTime")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间", name = "endTime")
    private Date endTime;

    /**
     * 起始页
     */
    @ApiModelProperty(value = "起始页", name = "pageNo")
    private Integer pageNo;

    /**
     * 页大小
     */
    @ApiModelProperty(value = "页大小", name = "pageSize")
    private Integer pageSize;

    private Integer startNum;

    private Integer endNum;
}
