package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("SchemeVipVo")
public class SchemeVipVo implements Serializable {
    private static final long serialVersionUID = 1372044868981609886L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 大专业名称
     */
    @ApiModelProperty(value = "大专业名称：如 ‘法学、文学、外语’", name = "bigMajorNames")
    private String bigMajorNames;

    /**
     * 专业ids
     */
    @ApiModelProperty(value = "专业ids,如'1,2,3,4,5,6...'", name = "professionIds")
    private String professionIds;

    /**
     * 文化课成绩
     */
    @ApiModelProperty(value = "文化课成绩", name = "cultureGrade")
    private String cultureGrade;

    /**
     * 专业课成绩
     */
    @ApiModelProperty(value = "专业课成绩", name = "majorGrade")
    private String majorGrade;

    /**
     * 地区
     */
    @ApiModelProperty(value = "地区", name = "local")
    private String local;

    /**
     * 综合成绩
     */
    @ApiModelProperty(name = "total",value = "综合成绩")
    private Integer total;

    /**
     * 是否展示全部  0:否  1：是
     */
    @ApiModelProperty(value = "是否展示全部  0:否  1：是", name = "isShowAll")
    private Integer isShowAll;
}
