package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 发送短信验证码Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/26 15:06
 */
@Data
@ApiModel(value = "SendSmsVo")
public class SendSmsVo implements Serializable {
    private static final long serialVersionUID = -1072677301838222102L;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码", name = "phone")
    private String phone;

    /**
     * 来源  1:PC 2:APP
     */
    @ApiModelProperty(value = "来源  1:PC 2:APP", name = "source")
    private Integer source;

    /**
     * 场景 1：短信登录 2：短信注册 3：短信修改密码 4：短信找回密码 5：短信重置密码
     */
    @ApiModelProperty(value = "场景 1：短信登录 2：短信注册 3：短信修改密码 4：短信找回密码 5：短信重置密码", name = "scene")
    private Integer scene;
}
