package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @ Description: 用户信息Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/7 11:14
 * @author 86187
 */
@Data
@ApiModel(value = "UserInfoVo")
public class UserInfoVo implements Serializable {
    private static final long serialVersionUID = 6175769905046107052L;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称", name = "userName")
    private String userName;

    /**
     * 性别 0：男 1：女
     */
    @ApiModelProperty(value = "性别 0：男 1：女", name = "sex")
    private Integer sex;

    /**
     * 考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生
     */
    @ApiModelProperty(value = "考生类型 1：文化课考生 2：美术生 3：体育生 4：文学编导考生", name = "studentType")
    private Integer studentType;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机号", name = "phone")
    private String phone;

    /**
     * sessionId
     */
    @ApiModelProperty(value = "sessionId", name = "sessionId")
    private String sessionId;
}
