package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author 86187
 * @ Description: 用户登录Vo
 * @ Author     : 86187
 * @ Date       : 2021/1/15 14:27
 */
@Data
@ApiModel(value = "UserLoginVo")
public class UserLoginVo implements Serializable {
    private static final long serialVersionUID = 2206962675782086034L;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码", name = "phone")
    private String phone;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", name = "password")
    private String password;

    /**
     * 验证码
     */
    @ApiModelProperty(value = "验证码", name = "code")
    private String code;

    /**
     * 场景类型：1:验证码登录 2:手机注册 3:修改密码 4：找回密码
     */
    @ApiModelProperty(value = "场景类型：1:验证码登录 2:手机注册 3:修改密码 4：找回密码 5：短信重置密码", name = "scene")
    private Integer scene;

    /**
     * 来源 1：PC 2：h5 3:小程序
     */
    @ApiModelProperty(value = "来源 1：PC 2：h5 3:小程序", name = "source")
    private Integer source;
}
